import 'package:photogram_admin_cp/import/core.dart';

/// It's sent when something went wrong while saving setting
/// through admin panel.
///
class AdminSettinSaveResultsDTO {
  var _isDTO = false;

  static const dtoName = 'admin_setting_save_results_dto';

  /*
  |--------------------------------------------------------------------------
  | data
  |--------------------------------------------------------------------------
  */

  late final String resultType;
  late final String settingKey;
  late final String message;

  /*
  |--------------------------------------------------------------------------
  | getters
  |--------------------------------------------------------------------------
  */

  bool get isDTO => _isDTO;
  bool get isNotDTO => !_isDTO;

  /*
  |--------------------------------------------------------------------------
  | from data
  |--------------------------------------------------------------------------
  */

  AdminSettinSaveResultsDTO({
    required this.resultType,
    required this.settingKey,
    required this.message,
  }) : _isDTO = true;

  /*
  |--------------------------------------------------------------------------
  | from json
  |--------------------------------------------------------------------------
  */

  AdminSettinSaveResultsDTO.fromJson(Map<String, dynamic> jsonMap) {
    /*
    |--------------------------------------------------------------------------
    | try setting all fields:
    |--------------------------------------------------------------------------
    */
    try {
      resultType = jsonMap[keyResultType];
      settingKey = jsonMap[keySettingKey];
      message = jsonMap[keyMessage];

      _isDTO = true;
    } catch (e) {
      AppLogger.info(e, logType: AppLogType.parser);
    }
  }

  /*
  |--------------------------------------------------------------------------
  | to json
  |--------------------------------------------------------------------------
  */

  Map<String, dynamic> toJson() => {
        keyResultType: resultType,
        keySettingKey: settingKey,
        keyMessage: message,
      };

  /*
  |--------------------------------------------------------------------------
  | key maps, warning! must not change
  |--------------------------------------------------------------------------
  */

  static const keyResultType = 'result_type';

  static const keySettingKey = 'setting_key';

  static const keyMessage = 'message';
}
